/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.Block0Descriptor;
import java.util.Vector;

public class TimingDescriptor
extends Block0Descriptor {
    private int iPixelClock_lowerByte;
    private int iPixelClock_upperByte;
    private int iHorizActive;
    private int iHorizBlanking;
    private int iVertActive;
    private int iVertBlanking;
    private int iHorizSyncOffset;
    private int iHorizSyncPulseWidth;
    private int iVertSyncOffset;
    private int iVertSyncPulseWidth;
    private int iHorizImageSize;
    private int iVertImageSize;
    private int iHorizBorder;
    private int iVertBorder;
    private int iFlags;
    private Vector<String> preDefs;

    public TimingDescriptor() {
        super(0);
        this.initVector();
    }

    public TimingDescriptor(String string) {
        super(0);
        this.initVector();
        int n = this.preDefs.indexOf(string);
        if (n != -1) {
            this.uploadDescriptorData(this.preDefs.get(n + 1).toString());
        }
    }

    private void initVector() {
        this.preDefs = new Vector();
        this.preDefs.add("1080i30(60Hz) 16:9");
        this.preDefs.add("011D8018711C1620582C250020C23100009E");
        this.preDefs.add("720p60 16:9");
        this.preDefs.add("011D007251D01E206E28550020C23100001E");
        this.preDefs.add("480p60 4:3");
        this.preDefs.add("8C0AD08A20E02D10103E9600138E21000018");
        this.preDefs.add("480p60 16:9");
        this.preDefs.add("8C0AD08A20E02D10103E960020C231000018");
    }

    public String getDisplayName() {
        return "Timing Descriptor";
    }

    public void setPixelClock(String string) {
        double d = Double.valueOf(string);
        if (d < 1.0) {
            this.iPixelClock_lowerByte = 0;
            this.iPixelClock_lowerByte = 0;
        } else {
            int n = (int)(d * 100.0);
            this.iPixelClock_lowerByte = n & 0xFF;
            this.iPixelClock_upperByte = n >> 8 & 0xFF;
        }
    }

    public String getPixelClock() {
        double d = (this.iPixelClock_upperByte << 8) + this.iPixelClock_lowerByte;
        return String.valueOf(d / 100.0);
    }

    public void setHorizontalActive(String string) {
        this.iHorizActive = Integer.valueOf(string);
    }

    public String getHorizontalActive() {
        return String.valueOf(this.iHorizActive);
    }

    public void setHorizontalBlanking(String string) {
        this.iHorizBlanking = Integer.valueOf(string);
    }

    public String getHorizontalBlanking() {
        return String.valueOf(this.iHorizBlanking);
    }

    public void setVerticalActive(String string) {
        this.iVertActive = Integer.valueOf(string);
    }

    public String getVerticalActive() {
        return String.valueOf(this.iVertActive);
    }

    public void setVerticalBlanking(String string) {
        this.iVertBlanking = Integer.valueOf(string);
    }

    public String getVerticalBlanking() {
        return String.valueOf(this.iVertBlanking);
    }

    public void setHorizontalSyncOffset(String string) {
        this.iHorizSyncOffset = Integer.valueOf(string);
    }

    public String getHorizontalSyncOffset() {
        return Integer.toString(this.iHorizSyncOffset);
    }

    public void setHorizontalSyncPulseWidth(String string) {
        this.iHorizSyncPulseWidth = Integer.valueOf(string);
    }

    public String getHorizontalSyncPulseWidth() {
        return Integer.toString(this.iHorizSyncPulseWidth);
    }

    public void setVerticalSyncOffset(String string) {
        this.iVertSyncOffset = Integer.valueOf(string);
    }

    public String getVerticalSyncOffset() {
        return Integer.toString(this.iVertSyncOffset);
    }

    public void setVerticalSyncPulseWidth(String string) {
        this.iVertSyncPulseWidth = Integer.valueOf(string);
    }

    public String getVerticalSyncPulseWidth() {
        return Integer.toString(this.iVertSyncPulseWidth);
    }

    public void setHoriztonalImageSize(String string) {
        this.iHorizImageSize = Integer.valueOf(string);
    }

    public String getHoriztonalImageSize() {
        return String.valueOf(this.iHorizImageSize);
    }

    public void setVerticalImageSize(String string) {
        this.iVertImageSize = Integer.valueOf(string);
    }

    public String getVerticalImageSize() {
        return String.valueOf(this.iVertImageSize);
    }

    public void setHorizontalBorder(String string) {
        this.iHorizBorder = Integer.valueOf(string);
    }

    public String getHorizontalBorder() {
        return String.valueOf(this.iHorizBorder);
    }

    public void setVerticalBorder(String string) {
        this.iVertBorder = Integer.valueOf(string);
    }

    public String getVerticalBorder() {
        return String.valueOf(this.iVertBorder);
    }

    public void setInterlaced(String string) {
        int n = Integer.valueOf(string);
        n = n << 7 & 0xFF;
        this.iFlags &= 0x7F;
        this.iFlags = n | this.iFlags;
    }

    public String getInterlaced() {
        return String.valueOf(this.iFlags >> 7);
    }

    public void setStereo(int n) {
        switch (n) {
            case 0: {
                int n2 = 158;
                this.iFlags &= n2;
                break;
            }
            case 1: {
                int n3 = 206;
                this.iFlags &= n3;
                n3 = 32;
                this.iFlags |= n3;
                break;
            }
            case 2: {
                int n4 = 158;
                this.iFlags &= n4;
                n4 = 64;
                this.iFlags |= n4;
                break;
            }
            case 3: {
                int n5 = 158;
                this.iFlags &= n5;
                n5 = 33;
                this.iFlags |= n5;
                break;
            }
            case 4: {
                int n6 = 158;
                this.iFlags &= n6;
                n6 = 96;
                this.iFlags |= n6;
                break;
            }
            case 5: {
                int n7 = 158;
                this.iFlags &= n7;
                n7 = 97;
                this.iFlags |= n7;
            }
        }
    }

    public int getStereo() {
        int n = this.iFlags;
        int n2 = 0;
        if ((n &= 0x61) == 0 | n == 1) {
            n2 = 0;
        }
        if (n == 32) {
            n2 = 1;
        }
        if (n == 64) {
            n2 = 2;
        }
        if (n == 33) {
            n2 = 3;
        }
        if (n == 65) {
            n2 = 4;
        }
        if (n == 96) {
            n2 = 5;
        }
        if (n == 97) {
            n2 = 6;
        }
        return n2;
    }

    public void setComposite(int n) {
        int n2 = 231;
        this.iFlags &= n2;
        switch (n) {
            case 0: {
                n2 = 231;
                this.iFlags &= n2;
                break;
            }
            case 1: {
                n2 = 8;
                this.iFlags |= n2;
                break;
            }
            case 2: {
                n2 = 16;
                this.iFlags |= n2;
                break;
            }
            case 3: {
                n2 = 24;
                this.iFlags |= n2;
                break;
            }
        }
    }

    public int getComposite() {
        int n = this.iFlags >> 3;
        return n &= 3;
    }

    public void setOption_1(int n) {
        int n2 = 251;
        this.iFlags &= n2;
        this.iFlags |= n << 2;
    }

    public int getOption_1() {
        int n = 4;
        return (this.iFlags & n) >> 2;
    }

    public void setOption_2(int n) {
        int n2 = 253;
        this.iFlags &= n2;
        this.iFlags |= n << 1;
    }

    public int getOption_2() {
        int n = 2;
        return (this.iFlags & n) >> 1;
    }

    public String extractDescriptorData() {
        String string = new String(String.format("%02X", this.iPixelClock_lowerByte));
        string = string.concat(String.format("%02X", this.iPixelClock_upperByte));
        int n = this.iHorizActive & 0xFF;
        int n2 = this.iHorizActive >> 8;
        int n3 = this.iHorizBlanking & 0xFF;
        int n4 = this.iHorizBlanking >> 8;
        string = string.concat(String.format("%02X", n));
        string = string.concat(String.format("%02X", n3));
        int n5 = n2 << 4 | n4;
        string = string.concat(String.format("%02X", n5));
        n = this.iVertActive & 0xFF;
        n2 = this.iVertActive >> 8;
        n3 = this.iVertBlanking & 0xFF;
        n4 = this.iVertBlanking >> 8;
        string = string.concat(String.format("%02X", n));
        string = string.concat(String.format("%02X", n3));
        n5 = n2 << 4 | n4;
        string = string.concat(String.format("%02X", n5));
        int n6 = this.iHorizSyncOffset & 0xFF;
        int n7 = this.iHorizSyncOffset >> 8;
        int n8 = this.iHorizSyncPulseWidth & 0xFF;
        int n9 = this.iHorizSyncPulseWidth >> 8;
        string = string.concat(String.format("%02X", n6));
        string = string.concat(String.format("%02X", n8));
        int n10 = this.iVertSyncOffset & 0xF;
        int n11 = this.iVertSyncOffset >> 4;
        int n12 = this.iVertSyncPulseWidth & 0xF;
        int n13 = this.iVertSyncPulseWidth >> 4;
        n5 = n10 << 4 | n12;
        string = string.concat(String.format("%02X", n5));
        n5 = 0;
        n5 = n7 << 2 | n9;
        n5 = n5 << 2 | n11;
        n5 = n5 << 2 | n13;
        string = string.concat(String.format("%02X", n5));
        int n14 = this.iHorizImageSize & 0xFF;
        string = string.concat(String.format("%02X", n14));
        n14 = this.iVertImageSize & 0xFF;
        string = string.concat(String.format("%02X", n14));
        n5 = this.iHorizImageSize >> 8 << 4 | this.iVertImageSize >> 8;
        string = string.concat(String.format("%02X", n5));
        string = string.concat(String.format("%02X", this.iHorizBorder));
        string = string.concat(String.format("%02X", this.iVertBorder));
        string = string.concat(String.format("%02X", this.iFlags));
        return string;
    }

    public void uploadDescriptorData(String string) {
        this.iPixelClock_lowerByte = Integer.parseInt(string.substring(0, 2), 16);
        this.iPixelClock_upperByte = Integer.parseInt(string.substring(2, 4), 16);
        this.iHorizActive = Integer.parseInt(string.substring(4, 6), 16);
        this.iHorizBlanking = Integer.parseInt(string.substring(6, 8), 16);
        this.iHorizActive |= Integer.parseInt(string.substring(8, 10), 16) >> 4 << 8;
        this.iHorizBlanking |= (Integer.parseInt(string.substring(8, 10), 16) & 0xF) << 8;
        this.iVertActive = Integer.parseInt(string.substring(10, 12), 16);
        this.iVertBlanking = Integer.parseInt(string.substring(12, 14), 16);
        this.iVertActive |= Integer.parseInt(string.substring(14, 16), 16) >> 4 << 8;
        this.iVertBlanking |= (Integer.parseInt(string.substring(14, 16), 16) & 0xF) << 8;
        this.iHorizSyncOffset = Integer.parseInt(string.substring(16, 18), 16);
        this.iHorizSyncPulseWidth = Integer.parseInt(string.substring(18, 20), 16);
        this.iVertSyncOffset = Integer.parseInt(string.substring(20, 22), 16) >> 4;
        this.iVertSyncPulseWidth = Integer.parseInt(string.substring(20, 22), 16) & 0xF;
        int n = Integer.parseInt(string.substring(22, 24), 16);
        this.iHorizSyncOffset |= n >> 6 << 8;
        this.iHorizSyncPulseWidth |= (n &= 0x3F) >> 4 << 8;
        this.iVertSyncOffset |= (n &= 0xF) >> 2 << 4;
        this.iVertSyncPulseWidth |= (n &= 3) << 4;
        this.iHorizImageSize = Integer.parseInt(string.substring(24, 26), 16);
        this.iVertImageSize = Integer.parseInt(string.substring(26, 28), 16);
        n = Integer.parseInt(string.substring(28, 30), 16);
        this.iHorizImageSize |= n >> 4 << 8;
        this.iVertImageSize |= (n & 0xF) << 8;
        this.iHorizBorder = Integer.parseInt(string.substring(30, 32), 16);
        this.iVertBorder = Integer.parseInt(string.substring(32, 34), 16);
        this.iFlags = Integer.parseInt(string.substring(34, 36), 16);
    }
}

